<xsl:stylesheet 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:ns1="https://puesc.gov.pl/ZEFIR2/xsd/v5_1/ZPNW.xsd" 
xmlns:zpnw="https://puesc.gov.pl/ZEFIR2/xsd/v5_1/ZPNW.xsd"
xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" 
xmlns:fr="http://puesc.gov.pl/ZEFIR2/xsd/v6_0/ForeignTrader.xsd" 
xmlns:ns5="http://puesc.gov.pl/ZEFIR2/xsd/v6_0/ForeignTrader.xsd" 
xmlns:ns3="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Types.xsd" 
xmlns:tp="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Types.xsd" 
xmlns:ns4="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Trader.xsd" 
xmlns:tr="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Trader.xsd" 
 
version="1.0">
	<xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/>
	<xsl:output encoding="iso-8859-1" method="html"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- POCZATEK ALL -->
	<!-- STYL ARKUSZA -->
	<xsl:template match="*" mode="styl1">
		<style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style>
		<style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style>
		<style type="text/css">a{color:#3366FF;font-weight:bold;}</style>
		<style type="text/css">h3{padding:3px;cursor:help;}</style>
		<style type="text/css">h4,h5,.copyr{text-align:center;}</style>
		<style type="text/css">caption{font-weight:bold;}</style>
		<style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style>
		<style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">#cont{display:none}</style>
		<style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style>
		<style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style>
		<style type="text/css">.nag2{font-size: 20px}</style>
		<style type="text/css">.cz10 {font-size: 10px}</style>
		<style type="text/css">.cz12 {	font-size: 12px}</style>
		<style type="text/css">.cz18 {font-size: 18px}</style>
		<style type="text/css">.cz16 {font-size: 16px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
	</xsl:template>
	<!-- SZABLON STOPKI -->
	<xsl:template match="*" mode="stopka">
		<xsl:text>ZPNW</xsl:text>
	</xsl:template>
	<xsl:template match="*">
		<!-- ZASTOSOWANIE STYLU -->
		<xsl:apply-templates mode="styl1" select="*"/>
		<!-- DEKLARACJE AKCYZOWE -->
		<xsl:apply-templates mode="dekl_ZPNW" select="."/>
	</xsl:template>
	<!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH -->
	<xsl:template match="*" mode="dekl_ZPNW">
		<xsl:for-each select=" ns1:Header|  ns1:* | zpnw:*">
			<xsl:apply-templates mode="Ident" select="."/>
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
			<xsl:apply-templates mode="PodstawaPrawna" select="."/>
			<xsl:apply-templates mode="MiejsceDekl" select="."/>
			<xsl:apply-templates mode="Cel" select="."/>
			<xsl:apply-templates mode="DaneZglaszajacego" select="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:* | fr:* "/>
			<xsl:apply-templates mode="AdresZglaszajacego" select="ns1:Declarant | zpnw:Declarant | ns4:* | tr:* | ns5:* | fr:* "/>
			<xsl:apply-templates mode="DaneNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:* | fr:*"/>
			<xsl:apply-templates mode="AdresNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:* | fr:*"/>
			<xsl:apply-templates mode="Miejsce" select="."/>
			<xsl:apply-templates mode="RodzZab" select="."/>
			<!-- <xsl:apply-templates mode="DaneReprezentanta" select="ns1:Representative | zpnw:Representative | ns4:* | tr:* | ns5:* | fr:*"/> -->
			<xsl:apply-templates mode="Wyroby" select="."/>
			<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
			<xsl:apply-templates mode="Miejscowosc" select="."/>
			<xsl:apply-templates mode="Reprezentacja" select="."/>
			<!-- <xsl:apply-templates mode="OswPodatnika" select="."/> -->
			<!-- SZABLON DOT. ADNOTACJI-->
			<xsl:apply-templates mode="Adnotacje" select="."/>
			<!-- SZABLON DOT. OBJASNIENIA -->
			<xsl:apply-templates mode="ObjasnieniaAkc" select="."/>
			<!-- SZABLON DOT. POUCZENIA-->
			<xsl:apply-templates mode="PouczeniaAkc" select="."/>
		</xsl:for-each>
	</xsl:template>
	<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
	<xsl:template match="*" mode="Ident">
		<table border="1" width="955">
			<tr align="left" valign="top">
				<td align="left" colspan="2" height="45" valign="middle" width="586">
					<span class="cz12">
						<xsl:choose>
							<xsl:when test="string-length(@identifier)='10'">
								<b>Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b>podatnika</b>
							</xsl:when>
							<xsl:otherwise>
								<b>
									<s>Identyfikator podatkowy NIP</s>/numer PESEL </b>
								<sup>(niepotrzebne skreślić)</sup>
								<b>podatnika</b>
							</xsl:otherwise>
						</xsl:choose>
					</span>
				</td>
				<td align="center" colspan="2" valign="middle" width="353">
					<span class="nag2">
						<b>
							<xsl:value-of select="@identifier"/>
						</b>
					</span>
				</td>
			</tr>
			<tr align="left" colspan="1" valign="top">
				<td align="left" height="45" valign="top" width="353"/>
				<td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top">
					<b>Nr dokumentu</b>
					<br/>
					<span class="cz16">
						<b>
							<xsl:value-of select="@selfRef"/>
						</b>
					</span>
				</td>
				<td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top">
					<b>Status</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT.  RODZAJU DEKLARACJI -->
	<xsl:template match="*" mode="rodz_dekl">
		<xsl:if test="ns1:* | zpnw:*">
			<table width="955">
				<tr>
					<td align="center" valign="middle">
						<div class="cz16">
							<b> ZGŁOSZENIE O PLANOWANYM NABYCIU WEWNĄTRZWSPÓLNOTOWYM POZA PROCEDURĄ <br/> ZAWIESZENIA POBORU AKCYZY WYROBÓW AKCYZOWYCH NIEWYMIENIONYCH W ZAŁĄCZNIKU NR 2<br/> DO USTAWY Z DNIA 6 GRUDNIA 2008 R. O PODATKU AKCYZOWYM, OBJĘTYCH STAWKĄ AKCYZY<br/> INNĄ NIŻ STAWKA ZEROWA, NA POTRZEBY WYKONYWANEJ NA TERYTORIUM KRAJU<br/> DZIAŁALNOŚCI GOSPODARCZEJ</b>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
	<xsl:template match="*" mode="PodstawaPrawna">
		<xsl:if test="ns1:* | zpnw:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top" width="115">Podstawa prawna: </td>
					<td align="left" valign="top" width="824">art. 78 ust. 3 pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.), zwanej dalej „ustawą”</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="Cel">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="3">
					<span class="nag1">2. CEL ZŁOŻENIA </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" width="50"/>
				<td align="left" colspan="2" valign="top">
					<b>2. Cel złożenia zgłoszenia</b>(zaznaczyć właściwy kwadrat): <br/>
					<br/>
					<p>
						<xsl:choose>
							<xsl:when test="//@submissionAim='Deklaracja'">
								<span class="cz18"> ☑ </span>1. złożenie zgłoszenia <span class="cz18">☐</span>  2. korekta zgłoszenia </xsl:when>
							<xsl:otherwise>
								<b/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="//@submissionAim='Korekta'">
								<span class="cz18"> ☐</span> 1. złożenie zgłoszenia <span class="cz18">☑</span>  2. korekta zgłoszenia </xsl:when>
							<xsl:otherwise>
								<b/>
							</xsl:otherwise>
						</xsl:choose>
					</p>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
	<xsl:template match="*" mode="MiejsceDekl">
		<xsl:if test="ns1:* | zpnw:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="3">
						<span class="nag1">1. MIEJSCE SKŁADANIA ZGŁOSZENIA</span>
					</td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" width="50"/>
					<td align="left" colspan="2" valign="top">
						<b>1. Naczelnik urzędu skarbowego, do którego składane jest zgłoszenie<sup>1)</sup>
						</b>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@taxOfficeName"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="Miejsce">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="3">
					<span class="nag1">5. MIEJSCE DOSTAWY</span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" width="50"/>
				<td align="left" colspan="2" valign="top">
					<b>5. Przewidywane miejsce (adres) i data dostawy</b>(rok-miesiąc-dzień) <br/>
					<span class="cz18">
						<xsl:value-of select="//@expectedDeliveryPlace"/>
					</span>
					<br/>
					<span class="cz18">
						<xsl:value-of select="//@expectedDateOfArrival"/>
					</span>
				</td>
			</tr>
		</table>
		<table width="955">
			<tr align="right" valign="top">
				<td colspan="3">
					<span class="nag1">ZPNW</span>
					<sub style="cz9"/>
					<b style="nag1">(5.1)/1</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Dane zglaszajacego -->
	<xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  | fr:*" mode="DaneZglaszajacego">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag1">3. ZGŁASZAJĄCY<sup>2)</sup>
					</span>
				</td>
			</tr>
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag2">3.1. DANE IDENTYFIKACYJNE </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" colspan="3" height="27" valign="top">
					<b>Rodzaj zgłaszającego </b>(zaznaczyć właściwy kwadrat): </td>
			</tr>
			<tr>
				<xsl:if test="//ns1:Declarant/@typeOfTaxpayer='N' ">
					<td align="left" valign="top" width="422">1. zgłaszający niebędący osobą fizyczną<br/>
						<span class="cz18"> ☑ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☐ </span>
					</td>
				</xsl:if>
				<xsl:if test="//ns1:Declarant/@typeOfTaxpayer='F' ">
					<td align="left" valign="top" width="422">1. zgłaszający niebędący osobą fizyczną<br/>
						<span class="cz18"> ☐ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☑ </span>
						<br/>
					</td>
				</xsl:if>
			</tr>
			<tr>
				<td align="left" colspan="3" valign="top">
					<b>Nazwa pełna /Nazwisko, pierwsze imię </b>
					<br/>
					<br/>
					<xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData | ns5:*">
						<span class="cz18">
							<xsl:value-of select="@fullName"/>
						</span>
					</xsl:for-each>
					<xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson | .//fr:PrivatePerson">
						<span class="cz18">
							<xsl:value-of select=".//@firstName"/>  </span>
						<span class="cz18">
							<xsl:value-of select=".//@surname"/>  </span>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Adres zglaszajacego -->
	<xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  " mode="AdresZglaszajacego">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="6">
					<span class="nag2">3.2. ADRES SIEDZIBY / ADRES ZAMIESZKANIA </span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td width="269">
					<b>Kraj </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@countryName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Województwo</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@provinceName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Powiat</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@districtName"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td>
					<b>Gmina </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@communeName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Ulica</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@street"/>
					</span>
				</td>
				<td width="144">
					<b>Nr domu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@houseNumber"/>
					</span>
				</td>
				<td width="151">
					<b>Nr lokalu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@localNumber"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td colspan="4">
					<b>Miejscowość</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@city"/>
					</span>
				</td>
				<td>
					<b>Kod pocztowy</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@postalCode"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Dane nadawcy -->
	<xsl:template match="ns1:Consignor | zpnw:Consignor  | ns4:* | tr:* | ns5:*  | fr:*" mode="DaneNadawcy">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag1">4. NADAWCA<sup>3)</sup>
					</span>
				</td>
			</tr>
			<tr bgcolor="#CCCCCC">
				<td colspan="4">
					<span class="nag2">4.1. DANE IDENTYFIKACYJNE </span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td align="left" colspan="3" height="27" valign="top">
					<b>Rodzaj nadawcy </b>(zaznaczyć właściwy kwadrat): </td>
			</tr>
			<tr>
				<xsl:if test="//ns1:Consignor/@typeOfTaxpayer='N' ">
					<td align="left" valign="top" width="422">1. nadawca niebędący osobą fizyczną<br/>
						<span class="cz18"> ☑ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☐ </span>
					</td>
				</xsl:if>
				<xsl:if test="//ns1:Consignor/@typeOfTaxpayer='F' ">
					<td align="left" valign="top" width="422">1. nadawca niebędący osobą fizyczną<br/>
						<span class="cz18"> ☐ </span>
					</td>
					<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
						<span class="cz18"> ☑ </span>
						<br/>
					</td>
				</xsl:if>
			</tr>
			<tr>
				<td align="left" colspan="3" valign="top">
					<b>Nazwa pełna /Nazwisko, pierwsze imię /NIP /Numer identyfikacyjny</b>
					<br/>
					<xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData | ns5:*">
						<span class="cz18">
							<xsl:value-of select="@fullName"/>
						</span>
					</xsl:for-each>
					<xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson | .//fr:PrivatePerson">
						<span class="cz18">
							<xsl:value-of select=".//@firstName"/>  </span>
						<span class="cz18">
							<xsl:value-of select=".//@surname"/>  </span>
					</xsl:for-each>
					<span class="cz18">
						<xsl:value-of select="//@consignorId"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Adres nadawcy -->
	<xsl:template match="zpnw:Consignor | ns1:Consignor | tr:* | ns4:* | ns5:* | fr:*" mode="AdresNadawcy">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="6">
					<span class="nag2">4.2. ADRES SIEDZIBY / ADRES ZAMIESZKANIA </span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
				<td width="269">
					<b>Kraj </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@countryName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Województwo</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@provinceName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Powiat</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@districtName"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td>
					<b>Gmina </b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@communeName"/>
					</span>
				</td>
				<td colspan="2">
					<b>Ulica</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@street"/>
					</span>
				</td>
				<td width="144">
					<b>Nr domu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@houseNumber"/>
					</span>
				</td>
				<td width="151">
					<b>Nr lokalu</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@localNumber"/>
					</span>
				</td>
			</tr>
			<tr align="left" valign="top">
				<td colspan="4">
					<b>Miejscowość</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@city"/>
					</span>
				</td>
				<td>
					<b>Kod pocztowy</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@postalCode"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Dane Reprezentanta -->
	<xsl:template match="zpnw:Representative | ns1:Representative" mode="DaneReprezentanta">
		<table border="1" width="955">
			<tr bgcolor="#CCCCCC">
				<td colspan="3">
					<span class="nag1">
						<b>DANE REPREZENTANTA</b>
					</span>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC" rowspan="2" width="46"/>
				<td align="left" valign="top" width="413">
					<b>24.Imię</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@firstName"/>
					</span>
				</td>
				<td align="left" valign="top" width="471">
					<b>25. Nazwisko</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@surname"/>
					</span>
				</td>
			</tr>
			<tr>
				<td align="left" colspan="2" valign="top">
					<b>26.Numer telefonu i adres e-mail</b>
					<br/>
					<br/>
					<span class="cz18">
						<xsl:value-of select=".//@phone"/>;<xsl:value-of select=".//@email"/>
					</span>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. Rodzaju zabezpieczenia -->
	<xsl:template match="zpnw:* |ns1:*" mode="RodzZab">
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always"/>
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="4">
					<span class="nag1">
						<b>6. ZABEZPIECZENIA AKCYZOWE</b>
					</span>
				</td>
			</tr>
			<!-- <tr align="center" bgcolor="#CCCCCC" valign="top"> <td> <span class="cz14"> Lp. </span> </td> <td> <span class="cz14">Numer zabezpieczenia akcyzowego </span> </td> <td> <span class="cz14">Kwota zabepieczenia akcyzowego </span> </td> <td> <span class="cz14">Data złożenia zabezpieczenia akcyzowego<br/> (dzień-miesiąc-rok) </span> </td> </tr> -->
			<xsl:if test="//zpnw:CollateralData/zpnw:GeneralData | //ns1:CollateralData/ns1:GeneralData">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="4">
						<span class="nag2">Zabezpieczenia generalne</span>
					</td>
				</tr>
				<tr align="center" bgcolor="#CCCCCC" valign="top">
					<td>
						<span class="cz14"> Lp. </span>
					</td>
					<td>
						<span class="cz14">7.1 Kwota zabezpieczenia akcyzowego w zł<sup>5) 6)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">8.1 Numer zabezpieczenia akcyzowego<sup>7)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">9.1 Data złożenia zabezpieczenia akcyzowego<sup>8)</sup>:<br/>
						</span>(dzień-miesiąc-rok) </td>
				</tr>
				<xsl:for-each select="//zpnw:GeneralData">
					<tr>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="position()"/>. </div>
						</td>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@amountOfExciseGuaranteeGeneral"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberGeneral"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@dateGeneral"/>
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="//zpnw:CollateralData/zpnw:FlatRateData | //ns1:CollateralData/ns1:FlatRateData">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="4">
						<span class="nag2"> Zabezpieczenia ryczałtowe</span>
					</td>
				</tr>
				<tr align="center" bgcolor="#CCCCCC" valign="top">
					<td>
						<span class="cz14"> Lp. </span>
					</td>
					<td>
						<span class="cz14">7.2 Kwota zabezpieczenia akcyzowego w zł<sup>5) 6)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">8.2 Numer zabezpieczenia akcyzowego<sup>7)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">9.2 Data złożenia zabezpieczenia akcyzowego<sup>8)</sup>:<br/>
						</span>(dzień-miesiąc-rok) </td>
				</tr>
				<xsl:for-each select="//zpnw:FlatRateData">
					<tr>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="position()"/>. </div>
						</td>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@amountOfExciseGuaranteeFlatRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberFlatRate"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@dateFlatRate"/>
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<!-- Zabezpieczenia pozostałe -->
			<xsl:if test="//zpnw:CollateralData/zpnw:OtherData | //ns1:CollateralData/ns1:OtherData">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="4">
						<span class="nag2"> Zabezpieczenia pozostałe<sup>4)</sup>
						</span>
					</td>
				</tr>
				<tr align="center" bgcolor="#CCCCCC" valign="top">
					<td>
						<span class="cz14"> Lp. </span>
					</td>
					<td>
						<span class="cz14">7.3 Kwota zabezpieczenia akcyzowego w zł<sup>5) 6)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">8.3 Numer zabezpieczenia akcyzowego<sup>7)</sup>
						</span>
					</td>
					<td>
						<span class="cz14">9.3 Data złożenia zabezpieczenia akcyzowego<sup>8)</sup>:<br/>
						</span> (dzień-miesiąc-rok) </td>
				</tr>
				<xsl:for-each select="//zpnw:OtherData">
					<tr>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="position()"/>. </div>
						</td>
						<td>
							<br/>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@amountOfExciseGuaranteeOther"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@numberOther"/>
							</div>
						</td>
						<td>
							<div align="right" class="cz18" valign="top">
								<xsl:value-of select="@dateOther"/>
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. WYROBOW -->
	<xsl:template match="ns1:* | zpnw:*" mode="Wyroby">
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<!-- <div style="page-break-before: always"/> -->
		<table border="1" width="955">
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td colspan="9">
					<span class="nag1">
						<b>10. DANE DOTYCZĄCE WYROBÓW AKCYZOWYCH PRZEWIDYWANYCH DO NABYCIA</b>
					</span>
				</td>
			</tr>
			<tr align="center" bgcolor="#CCCCCC" valign="top">
				<td>
					<span class="cz14">Lp. </span>
				</td>
				<td>
					<span class="cz14">Opis wyrobów </span>
				</td>
				<td>
					<span class="cz14">Kod CN </span>
				</td>
				<td>
					<span class="cz14">Płyn do papierosów elektronicznych zawarty w jednorazowym papierosie elektronicznym (zaznaczyć właściwy kwadrat) </span>
				</td>
				<td>
					<span class="cz14">Liczba jednorazowych papierosów elektronicznych zawierających płyn do papierosów elektronicznych </span>
				</td>
				<td>
					<span class="cz14">Ilość</span>
				</td>
				<td>
					<span class="cz14">Jednostka miary </span>
				</td>
				<td>
					<span class="cz14">Stawka akcyzy </span>
				</td>
				<td>
					<span class="cz14">Kwota akcyzy w zł<sup>6)</sup>
					</span>
				</td>
			</tr>
			<xsl:for-each select="//zpnw:Item | //ns1:Item">
				<tr>
					<td>
						<br/>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@id"/>
						</div>
					</td>
					<td>
						<div align="left" class="cz14" valign="top">
							<xsl:value-of select="@goodsName"/>
						</div>
						<div align="left" class="cz14" valign="top">
							<xsl:choose>
								<xsl:when test="//@groupOfGoodsName='urzadzenia-do-waporyzacji'">
									<xsl:value-of select="@typeOfVapingDevice"/>
								</xsl:when>
								<xsl:otherwise>
									<b/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="//@groupOfGoodsName!='urzadzenia-do-waporyzacji'">
									<xsl:value-of select="@groupOfGoodsName"/>
								</xsl:when>
								<xsl:otherwise>
									<b/>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<!--<div align="left" class="cz14" valign="top">
							<xsl:value-of select="@typeOfVapingDevice"/>
						</div>
						<div align="left" class="cz14" valign="top">
							<i>
								<b>
									<xsl:value-of select="@groupOfGoodsName"/>
								</b>
							</i>
						</div>-->
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@codeCN"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz14" valign="top">
							<xsl:choose>
								<xsl:when test="@cigaretteLiquidContainedInOne='true'"> ☑ tak / ☐ nie</xsl:when>
								<xsl:when test="@cigaretteLiquidContainedInOne='false'"> ☐ tak / ☑ nie</xsl:when>
							</xsl:choose>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@numberOfElectronicCigarettesContainingLiquid"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18">
							<xsl:value-of select="@valueOfGoods"/>
						</div>
						<div align="right" class="cz18">
							<xsl:value-of select="@numberOfGoods"/>
						</div>
						<!--	<br/> ______ </div> <div align="right" class="cz14"> <xsl:value-of select="@unitOfMeasure"/> <br/> ______ </div> -->
						<div align="right" class="cz18">
							<xsl:value-of select="@weightedAverageRetailPrice"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz14">
							<xsl:value-of select="@unitOfMeasure"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18">
							<xsl:value-of select="@taxRate"/>
						</div>
						<div align="right" class="cz18">
							<xsl:value-of select="@taxRatePercentage"/>
						</div>
						<div align="right" class="cz18">
							<xsl:value-of select="@taxMin"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/>
						</div>
					</td>
				</tr>
			</xsl:for-each>
			<!-- PODSUMOWANIE TABELKI -->
			<xsl:for-each select=".">
				<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
				<tr>
					<!--<td>-</td> -->
					<td bgcolor="#CCCCCC" colspan="5">
						<b>Łącznie<sup>9)</sup>: </b>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select=".//@numberSum"/>
						</div>
					</td>
					<td bgcolor="#CCCCCC" colspan="2">  </td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(.//@amountOfTaxSum),'# ##0')"/>
						</div>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. WYROBOW -->
	<xsl:template match="*" mode="Miejscowosc">
		<xsl:if test="ns1:* | ns3:* | zpnw:* | tp:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="3">
						<span class="nag1">11. MIEJSCOWOŚĆ I DATA ZŁOŻENIA ZGŁOSZENIA </span>
					</td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" width="50"/>
					<td align="left" colspan="2" valign="top">
						<b>11. Miejscowość i data złożenia zgłoszenia</b> (dzień–miesiąc–rok) <br/>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="substring(//@declarationDate,9,2)"/>
							<xsl:value-of select="substring(//@declarationDate,5,4)"/>
							<xsl:value-of select="substring(//@declarationDate,1,4)"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="Reprezentacja">
		<xsl:if test="ns1:* | ns3:* | zpnw:* | tp:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="3">
						<span class="nag1">12.IMIĘ I NAZWISKO ZGŁASZAJĄCEGO ALBO OSOBY REPREZENTUJĄCEJ</span>
					</td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" width="50"/>
					<td align="left" colspan="2" valign="top">
						<b>12. Imię i nazwisko zgłaszającego albo osoby reprezentującej zgłaszającego oraz fakultatywnie nr telefonu lub e-mail:</b>
						<br/>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repFirstName"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="//@repSurname "/>
						</span>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@phone | zpnw:Statement/zpnw:representative/@phone  "/>
						</span>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@email"/>
						</span>
					</td>
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" width="50"/>
						<td colspan="2">
							<b>Podpis zgłaszającego albo osoby reprezentującej zgłaszajacego <sup>10)</sup>
							</b>
							<span class="cz18">
								<br/>
							</span>
						</td>
					</tr>
					<tr align="left" valign="top">
						<td bgcolor="#CCCCCC" width="50"/>
						<td colspan="2">
							<xsl:choose>
								<xsl:when test="string-length(//@repIdentifier)= 11">
									<b>
										<s>Identyfikator podatkowy NIP</s>/numer PESEL</b>
									<sup>(niepotrzebne skreślić)</sup>
									<b> osoby składającej podpis</b>
								</xsl:when>
								<xsl:when test="string-length(//@repIdentifier)= 10">
									<b>Identyfikator podatkowy NIP/<s>numer PESEL</s>
									</b>
									<sup>(niepotrzebne skreślić)</sup>
									<b> osoby składającej podpis</b>
								</xsl:when>
								<xsl:otherwise>
									<b>Identyfikator podatkowy NIP/numer PESEL </b>
									<sup>(niepotrzebne skreślić)</sup>
									<b> osoby składającej podpis</b>
								</xsl:otherwise>
							</xsl:choose>
							<br/>
							<br/>
							<span class="cz18">
								<xsl:value-of select="//@repIdentifier"/>
							</span>
						</td>
					</tr>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
	<xsl:template match="*" mode="OswPodatnika">
		<xsl:if test="ns1:* | ns3:* | zpnw:* | tp:*">
			<table border="1" height="210" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="3">
						<b>
							<span class="nag1">12.IMIĘ I NAZWISKO ZGŁASZAJĄCEGO ALBO OSOBY REPREZENTUJĄCEJ ZGŁASZAJĄCEGO ORAZ FAKULTATYWNIE NR TELEFONU LUB E-MAIL:</span>
						</b>
						<!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.-->
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
					<td height="37" width="402">
						<b>Imię </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repFirstName"/>  </span>
					</td>
					<td width="491">
						<b>Nazwisko </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repSurname "/>  </span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="2">
						<b>Podpis zgłaszającego albo osoby reprezentującej zgłaszajacego <sup>10)</sup>
						</b>
						<span class="cz18">
							<br/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td height="39">
						<xsl:choose>
							<xsl:when test="string-length(//@repIdentifier)= 11">
								<b>
									<s>Identyfikator podatkowy NIP</s>/numer PESEL</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
							</xsl:when>
							<xsl:when test="string-length(//@repIdentifier)= 10">
								<b>Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
							</xsl:when>
							<xsl:otherwise>
								<b>Identyfikator podatkowy NIP/numer PESEL </b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
							</xsl:otherwise>
						</xsl:choose>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repIdentifier"/>
						</span>
					</td>
					<td>
						<b>11. Miejscowość i data złożenia zgłoszenia</b> (dzień – miesiąc – rok) <br/>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="substring(//@declarationDate,9,2)"/>
							<xsl:value-of select="substring(//@declarationDate,5,4)"/>
							<xsl:value-of select="substring(//@declarationDate,1,4)"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="3">
						<b>Numer telefonu i adres e-mail zgłaszającego albo osoby reprezentującej zgłaszającego</b> (pozycja fakultatywna) <br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@phone | zpnw:Statement/zpnw:representative/@phone  "/>  </span>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/ns3:representative/@email"/>  </span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADNOTACJI-->
	<xsl:template match="*" mode="Adnotacje">
		<xsl:if test="ns1:* | zpnw:*">
			<table border="1" height="167" width="955">
				<tr bgcolor="#CCCCCC">
					<td class="nag1" colspan="3" height="36">13. ADNOTACJE URZĘDU SKARBOWEGO </td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td rowspan="2" width="40"/>
					<td colspan="2" height="72">
						<b>13.Adnotacje Urzędu Skarbowego <br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</b>
					</td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td height="49" width="472">
						<b>Identyfikator przyjmującego formularz <br/>
							<br/>
							<br/>
						</b>
						<p/>
					</td>
					<td width="421">
						<b>Podpis przyjmującego formularz </b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OBJASNIENIA -->
	<xsl:template match="*" mode="ObjasnieniaAkc">
		<xsl:if test="ns1:* | zpnw:*">
			<table width="955">
				<tr>
					<td>
						<p align="center">
							<b>Objaśnienia</b>
						</p>
						<br/>
						<p>
							<sup>1)</sup> Naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu podatkiem akcyzowym – zgodnie z art. 14 ust. 3 ustawy; jeżeli czynności podlegające opodatkowaniu podatkiem akcyzowym są wykonywane lub stany faktyczne podlegające opodatkowaniu podatkiem akcyzowym występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – naczelnik urzędu skarbowego ustalony zgodnie z art. 14 ust. 4–4f ustawy; Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie – w przypadku, o którym mowa w art. 14 ust. 10 ustawy.<br/>
							<sup>2)</sup>  Należy podać imię i nazwisko lub nazwę oraz adres zamieszkania lub siedziby oraz numer identyfikacji podatkowej (NIP).<br/>
							<sup>3)</sup>  Należy podać imię i nazwisko lub nazwę oraz adres zamieszkania lub siedziby nadawcy wyrobów akcyzowych w innym państwie członkowskim oraz jego NIP albo inny numer identyfikacyjny używany w państwie zamieszkania lub siedziby.<br/>
							<sup>4)</sup> Zabezpieczenie akcyzowe złożone dla zagwarantowania pokrycia wyłącznie jednego zobowiązania podatkowego lub jednego zobowiązania podatkowego oraz opłaty paliwowej.<br/>
							<sup>5)</sup>  Kwota zabezpieczenia akcyzowego obejmuje mogące powstać zobowiązanie/zobowiązania podatkowe albo mogące powstać zobowiązanie/zobowiązania podatkowe oraz opłatę paliwową, której obowiązek zapłaty może powstać.<br/>
							<sup>6)</sup>  Kwotę zabezpieczenia akcyzowego i kwotę podatku akcyzowego zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2021 r. poz. 1540, z późn. zm.).<br/>
							<sup>7)</sup>  Należy wypełnić w przypadku zaznaczenia w polu 6 kwadratu „generalne” albo „ryczałtowe”.<br/>
							<sup>8)</sup> Należy wypełnić w przypadku zaznaczenia w polu 6 kwadratu „pozostałe”.<br/>
							<sup>9)</sup> Należy wpisać odpowiednio łączną ilość nabywanych wewnątrzwspólnotowo wyrobów akcyzowych oraz łączną kwotę podatku akcyzowego.<br/>
							<sup>10)</sup> W przypadku złożenia zgłoszenia w postaci elektronicznej zgłoszenie to powinno być opatrzone podpisem elektronicznym weryfikowanym przy pomocy certyfikatu celnego albo innym podpisem elektronicznym zapewniającym autentyczność deklaracji i podań, zgodnie z rozporządzeniem wydanym na podstawie art. 3b § 2 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.  </p>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1">ZPNW</span>
						<sub style="cz9"/>
						<b style="nag1">(5.1)</b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- KONIEC all PK-->
</xsl:stylesheet>